unit Barfrm16;
{Warning: If the TBarcode component is not installed,
 You get an error message while loading this project!
 If this happens to You, You must close he project
 WITHOUT SAVING and read the documentation how
 to install TBarcode as a VCL-component.

 Documentation is in the files ENGLISH.DOC and DEUTSCH.DOC.

 If You have any problems installing or using TBarcode,
 please contact the author:
 Juergen Schlottke
 CIS-ID   100106,3034
 Internet 100106.3034@compuserve.com
 WWWeb    http://ourworld.compuserve.com/homepages/schlottke

 Consider that my mother language is German! So when
 You ask me in English, please write slowly <bg>.
 }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, ExtCtrls, Buttons, Bar16HL;

type
  TDemoForm = class(TForm)
    RGModulewidth: TRadioGroup;
    RGCodetyp: TRadioGroup;
    CB_ZoomSize: TCheckBox;
    CB_HighDensity: TCheckBox;
    CB_WidthReduce: TCheckBox;
    Edit1: TEdit;
    SE_HeightPerCent: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    PrintBtn1: TBitBtn;
    PrintBtn2: TBitBtn;
    Barcode1: TBarcode;
    ExitBtn: TButton;
    procedure ExitBtnClick(Sender: TObject);
    procedure PrintBtn1Click(Sender: TObject);
    procedure PrintBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure SE_HeightPerCentChange(Sender: TObject);
    procedure RGCodetypClick(Sender: TObject);
    procedure RGModulewidthClick(Sender: TObject);
    procedure CB_HighDensityClick(Sender: TObject);
    procedure CB_ZoomSizeClick(Sender: TObject);
    procedure CB_WidthReduceClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure PrintDemo1;
    procedure PrintDemo2;
  public
    { Public-Deklarationen }
  end;

var
  DemoForm: TDemoForm;

implementation
uses Printers;
{$R *.DFM}

procedure TDemoForm.ExitBtnClick(Sender: TObject);
begin
  Application.terminate;
end;



procedure TDemoForm.PrintDemo2;
{This print demo will create a barcode "on the fly" and
 use it for printer output. No visual object needed.}
var
  x,y,lineheight:Integer;
  xmm,ymm:Extended;
  Point:TPoint;
  MyBarcode:TBarcode;
begin
  MyBarcode:=TBarcode.create(self); {Create TBarcode object}
  With MyBarcode do {Set some default options}
  begin
    {Take Caption from the barcode visible on the screen}
    Bar_Caption:=Barcode1.Bar_caption;
    {Set normal Height}
    Bar_HeightPercent:=100;
    {No high density codes}
    Bar_HighDensity:=false;
    {Normal width ist SC2}
    Bar_Modulewidth:=SC2;
    {With Laserprinters always use Widthreduce:=false!!!}
    Bar_Widthreduce:=false;
    {While printing always use Bar_ZoomSize:=false!!!}
    Bar_ZoomSize:=false;
  end;
  printer.begindoc;
  {Find out: How many device units are one mm}
  xmm:=getdevicecaps(Printer.Handle,logpixelsX)/25.4;
  ymm:=getdevicecaps(Printer.Handle,logpixelsY)/25.4;
  {Find out printing offset on page}
  escape(Printer.handle,Getprintingoffset,0,nil,@point);
  {Adjust printing offset, so output starts at the
   same coordinates on all printers}
  SetViewPortOrgEx(Printer.handle,-point.x,-point.y,nil);
  Printer.Canvas.Font.Name:='Arial';
  Printer.Canvas.Font.Size:=12;
  lineheight:=Printer.Canvas.textheight('Ay');
  x:=round(25*xmm);
  y:=round(25*ymm);
  {EAN-8 demo}
  Printer.Canvas.Textout(x,y,'EAN-8-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=EAN_8;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  {EAN-13 demo}
  Printer.Canvas.Textout(x,y,'EAN-13-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=EAN_13;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  {UPC-A demo}
  Printer.Canvas.Textout(x,y,'UPC-A-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=UPC_A;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  {UPC-E demo}
  Printer.Canvas.Textout(x,y,'UPC-E-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=UPC_E;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  {CODE39 demo}
  Printer.Canvas.Textout(x,y,'Code 39-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=CODE39;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  {Code 2/5 interleaved demo}
  Printer.Canvas.Textout(x,y,'Code 2/5 interleaved-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=Code25i;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  printer.enddoc;
  MyBarcode.free;
end;


procedure TDemoForm.PrintDemo1;
var
  x,y,lineheight:Integer;
  xmm,ymm:Extended;
  Point:TPoint;
begin
  printer.begindoc;
  {Find out: How many device units are one mm}
  xmm:=getdevicecaps(Printer.Handle,logpixelsX)/25.4;
  ymm:=getdevicecaps(Printer.Handle,logpixelsY)/25.4;
  {Find out printing offset on page}
  escape(Printer.handle,Getprintingoffset,0,nil,@point);
  {Adjust printing offset, so output starts at the
   same coordinates on all printers}
  SetViewPortOrgEx(Printer.handle,-point.x,-point.y,nil);
  {Now Print the Barcode at}
  x:=round(50*Xmm);  {50mm from left}
  y:=round(60*Ymm);  {60mm from top}
  {Actual width and height of barcode are returned in "Point"}
  Barcode1.Print(Printer.canvas,x,y,@Point);
  x:=round(25*xmm);    {Set left:= 25mm}
  inc(y,Point.y);      {increment with height of barcode}
  inc(y,round(10*ymm));{increment 10mm}
  with Printer.canvas.font do
  begin
    name:='Arial';
    size:=12;
  end;
  {How many device units are one line printed with Arial-12}
  lineheight:=Printer.canvas.textheight('X');
  {Now print some lines of text}
  Printer.canvas.textout(x,y,'Top left corner of barcode should be placed at:');
  inc(y,lineheight);
  Printer.canvas.textout(x,y,'50mm from left, 60mm from top of page');
  inc(y,2*lineheight);
  If Barcode1.Bar_Zoomsize then
  begin
    Printer.canvas.textout(x,y,'Warning: With "Bar_Zoomsize:=true" Your barcodes might be bad!');
    inc(y,lineheight);
    Printer.canvas.textout(x,y,'Please use "Bar_Zoomsize:=false" for printing best barcodes!');
    inc(y,2*lineheight);
  end;
  If Barcode1.Bar_WidthReduce then
  begin
    Printer.canvas.textout(x,y,'"Warning: Bar_WidthReduce:=true"');
    inc(y,lineheight);
    Printer.canvas.textout(x,y,'This option should be used with dot-matrix and ink-jet printers only!');
    inc(y,lineheight);
    Printer.canvas.textout(x,y,'With laser printers You must use "Bar_WidthReduce:=false"!');
    inc(y,2*lineheight);
  end;
  Printer.canvas.textout(x,y,'The dimensions of the printed barcode are:');
  inc(y,lineheight);
  Printer.canvas.textout(x,y,format('%d device units (%2.1fmm) in X-direction',[point.x,point.x/xmm]));
  inc(y,lineheight);
  Printer.canvas.textout(x,y,format('%d device units (%2.1fmm) in Y-direction',[point.y,point.y/ymm]));
  printer.enddoc;
end;




procedure TDemoForm.PrintBtn1Click(Sender: TObject);
begin
  PrintDemo1;
end;


procedure TDemoForm.PrintBtn2Click(Sender: TObject);
begin
  PrintDemo2;
end;

procedure TDemoForm.FormCreate(Sender: TObject);
begin
  SE_HeightPercent.value:=Barcode1.Bar_HeightperCent;
  RGModuleWidth.itemindex:=ord(Barcode1.Bar_ModuleWidth);
  RGCodetyp.itemindex:=ord(Barcode1.Bar_Codetype);
  CB_HighDensity.checked:=Barcode1.Bar_HighDensity;
  CB_ZoomSize.checked:=Barcode1.Bar_ZoomSize;
  CB_WidthReduce.checked:=Barcode1.Bar_WidthReduce;
  Edit1.text:=Barcode1.Bar_Caption;
end;

procedure TDemoForm.Edit1Change(Sender: TObject);
begin
  Barcode1.Bar_Caption:=Edit1.text;
end;

procedure TDemoForm.SE_HeightPerCentChange(Sender: TObject);
begin
  Barcode1.Bar_HeightPercent:=SE_HeightPercent.value;
end;

procedure TDemoForm.RGCodetypClick(Sender: TObject);
begin
  Barcode1.Bar_CodeType:=btCodeTypes(RGCodetyp.itemindex);
end;

procedure TDemoForm.RGModulewidthClick(Sender: TObject);
begin
  Barcode1.Bar_Modulewidth:=btCodeSizes(RGModuleWidth.itemindex);
end;

procedure TDemoForm.CB_HighDensityClick(Sender: TObject);
begin
  Barcode1.Bar_HighDensity:=CB_HighDensity.checked;
end;

procedure TDemoForm.CB_ZoomSizeClick(Sender: TObject);
begin
  Barcode1.Bar_Zoomsize:=CB_ZoomSize.checked;
end;

procedure TDemoForm.CB_WidthReduceClick(Sender: TObject);
begin
  Barcode1.Bar_WidthReduce:=CB_WidthReduce.checked;
end;

procedure TDemoForm.FormPaint(Sender: TObject);
{Procedure will show how to calculate output positions}
var
  Point:TPoint;
  R:Trect;
begin
  {If You want to see Barcode1 with a bounding box, remove
   the comment brackets from the following source lines}
   (*
  {First print the Barcode in its own position to get dimensions}
  Barcode1.print(Canvas,Barcode1.left,Barcode1.top,@Point);
  {Width and height are in "Point", now calculate the bounding box}
  R:=rect(Barcode1.left,Barcode1.top,Barcode1.left+Point.x,Barcode1.top+Point.y);
  {paint the bounding box}
  canvas.framerect(R);
  *)
end;

end.

